#!/bin/bash
for version in $(ls build/); do
  if [ ! -z $CI_PROJECT_NAME ]; then
    if [[ -d /mnt/obit/public/ubuntu/$version && -d /mnt/obit/public/ubuntu/$version/$CI_PROJECT_NAME ]]; then
      cp build/$version/* /mnt/obit/public/ubuntu/$version/$CI_PROJECT_NAME/
      update-obit ubuntu $version $CI_PROJECT_NAME
    else
      echo "Ubuntu $version not found or $CI_PROJECT_NAME does not have $version dir."
    fi
  else
    echo "Couldnt determine project name. Not deploying."
    exit 1
  fi
done

