/* -------------------------------------------------------------------------- */
/* Copyright 2002-2016, OpenNebula Project, OpenNebula Systems                */
/*                                                                            */
/* Licensed under the Apache License, Version 2.0 (the "License"); you may    */
/* not use this file except in compliance with the License. You may obtain    */
/* a copy of the License at                                                   */
/*                                                                            */
/* http://www.apache.org/licenses/LICENSE-2.0                                 */
/*                                                                            */
/* Unless required by applicable law or agreed to in writing, software        */
/* distributed under the License is distributed on an "AS IS" BASIS,          */
/* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   */
/* See the License for the specific language governing permissions and        */
/* limitations under the License.                                             */
/* -------------------------------------------------------------------------- */

define(function(require) {

  var Sunstone = require('sunstone');
  var OpenNebula = require('opennebula');
  var Config = require('sunstone-config');

  var ZONE_TAB_ID = require('tabs/zones-tab/tabId');

  /*
    FUNCTION DEFINITIONS
   */

  function _init() {
    // init the zone list, needed for market & apps zone columns
    if (Config.isTabActionEnabled(ZONE_TAB_ID, "Zone.list")) {
      Sunstone.runAction("Zone.list");
    }

    OpenNebula.Datastore.initMarketExportSupported();
  }

  return {
    'init': _init
  };
});
